/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Int      lights=3; // number of lights (1..3)
Material material; // material light
Mesh     mbox    , // mesh box
         mball   , // mesh ball
         mlight  , // mesh light
         mballs  ; // mesh ball (shadow stencil version)
Vec      ball_pos[8], // ball  positions
        light_pos[3]; // light positions
/******************************************************************************/
void SetEffect()
{
   mbox .setEffect();
   mball.setEffect();
}
/******************************************************************************/
void InitPre()
{
   App.name="Rendering Demo";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");

   D.set_effect=SetEffect;
   D.full(true).bumpMode(BUMP_RELIEF).shdSoft(1).shdJitter(true);
}
/******************************************************************************/
Bool Init()
{
   // create materials
   Material *brick=Materials("../data/mtrl/brick/0.mtrl");
   material.reset().glow=0.6;

   // create meshes
   mbox  .create(1).B(0).create( Box(1   ),VTX_TX0|VTX_NRM|VTX_TNG).reverse(       ); // create mesh box , reverse it because it's meant to be viewed from inside
   mball .create(1).B(0).create(Ball(0.15),VTX_TX0|VTX_NRM|VTX_TNG).weldVal(VTX_POS); // create mesh ball, weld it's vertex positions (stencil shadows are very sensitive to even the smallest irregularities)
   mlight.create(1).B(0).create(Ball(0.04));

   // set mesh materials, rendering versions and bounding boxes
   mbox  .setMaterial( brick   ).setRender().setBox();
   mball .setMaterial( brick   ).setRender().setBox();
   mlight.setMaterial(&material).setRender().setBox();

   // create stencil shadow version of ball mesh
   mball.copy(mballs).toStencilShadow();

   // set random positions
   REPA(ball_pos)ball_pos[i]=Rnd(Box(0.9));

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.01f,10,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   // update light positions when space is not pressed
   if(!Kb.b(KB_SPACE))
   {
      static Flt t; t+=Tm.d/2;
      light_pos[0].set(0,0,0.3); light_pos[0]*=Matrix3().setRotateX(t).rotateY(t/2  ).rotateZ(t/3  );
      light_pos[1].set(0,0,0.6); light_pos[1]*=Matrix3().setRotateX(t).rotateY(t/1.5).rotateZ(t/2.5);
      light_pos[2].set(0,0,0.5); light_pos[2]*=Matrix3().setRotateX(t).rotateY(t/1.3).rotateZ(t/3.2);
   }

   // change settings
   if(Kb.c=='1')lights=1;
   if(Kb.c=='2')lights=2;
   if(Kb.c=='3')lights=3;

   if(Kb.c=='q')D.shdMode(SHD_NONE);
   if(Kb.c=='w')D.shdMode(SHD_MAP    ).shdSoft(0);
   if(Kb.c=='e')D.shdMode(SHD_MAP    ).shdSoft(1);
   if(Kb.c=='r')D.shdMode(SHD_MAP_HW ).shdSoft(0);
   if(Kb.c=='t')D.shdMode(SHD_MAP_HW ).shdSoft(1);
   if(Kb.c=='y')D.shdMode(SHD_STENCIL).shdSoft(0);
   if(Kb.c=='u')D.shdMode(SHD_STENCIL).shdSoft(1);

   if(Kb.c=='a')D.bumpMode(BUMP_FLAT    );
   if(Kb.c=='s')D.bumpMode(BUMP_NORMAL  );
   if(Kb.c=='d')D.bumpMode(BUMP_PARALLAX);
   if(Kb.c=='f')D.bumpMode(BUMP_RELIEF  );

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SHD_STNC:
         REPA(ball_pos)mballs.draw(Matrix(ball_pos[i]));
      break;

      case RM_EARLY_Z:
      case RM_SHD_MAP:
      case RM_SOLID  :
                       mbox .draw(MatrixIdentity);
         REPA(ball_pos)mball.draw(Matrix(ball_pos[i]));

         if(Renderer()!=RM_SHD_MAP) // don't render light balls in shadow mapping mode - this will disable casting shadows for them
         {
                          material.color.v3.set(1  ,1,0.5); mlight.draw(Matrix(light_pos[0]));
            if(lights>=2){material.color.v3.set(0.5,1,1  ); mlight.draw(Matrix(light_pos[1]));}
            if(lights>=3){material.color.v3.set(0.5,1,0.5); mlight.draw(Matrix(light_pos[2]));}
         }
      break;

      case RM_LIGHT: 
         REP(lights)mlight.draw(Matrix(light_pos[i]));

         switch(lights)
         {
            case 1:
               LightPoint(0.50,light_pos[0],Vec(1)).add();
            break;

            case 2:
               LightPoint(0.45,light_pos[0],Vec(1,0.5,0.0)).add();
               LightPoint(0.45,light_pos[1],Vec(0,0.5,1.0)).add();
            break;

            case 3:
               LightPoint(0.40,light_pos[0],Vec(1  ,0.3,0.0)).add();
               LightPoint(0.40,light_pos[1],Vec(0.0,0.3,1  )).add();
               LightPoint(0.40,light_pos[2],Vec(0.0,0.4,0.0)).add();
            break;
         }
      break;
   }
}
void Draw()
{
   Renderer(Render);
}
/******************************************************************************/
